PlayerStandard.MOVER_STAND = Idstring("duck")
local init = PlayerStandard.init
function PlayerStandard:init(unit)
	init(self, unit)
	self._slotmask_bullet_impact_targets = self._slotmask_bullet_impact_targets - 2
	if self._unit:mover() then
		self._unit:kill_mover()
		self:_activate_mover(PlayerStandard.MOVER_STAND)
	end
end
local _unit_alive_track_dealy = 0
local _unit_alive_track = 0
local _unit_alive_track_bool = false
local _current_state_name = ""
local _talk_dealy = 0
local _primary_anim_recover_delay = 0
local update = PlayerStandard.update
function PlayerStandard:update(t, dt)
	update(self, t, dt)
	managers.player.locke:update(t, dt)
	if _unit_alive_track_dealy > t then
		return
	end
	_unit_alive_track_dealy = t + 3
	if Utils:IsInHeist() and managers.player and managers.player.locke and managers.player.locke:unit_alive() then
		if not _unit_alive_track_bool then
			_unit_alive_track = t + 1
			_unit_alive_track_bool = true
			dofile("mods/Locke Simulator/Compatible/WolfHUD/copdamage.lua")
			dofile("mods/Locke Simulator/Compatible/Damage2Player/copdamage.lua")
			dofile("mods/Locke Simulator/Compatible/NoMarkEnemy/contourext.lua")
			dofile("mods/Locke Simulator/Compatible/NoMarkEnemy/unitnetworkhandler.lua")
			dofile("mods/Locke Simulator/Compatible/FixGameCrashWhenWin/missionendstate.lua")
			managers.player.locke:unit():brain():set_active(false, true)
		end
		if managers.player.locke:unit().character_damage and managers.player.locke:unit():character_damage():dead() and 
			_unit_alive_track > 0 and _unit_alive_track_bool then
			managers.player:force_drop_carry()
			managers.statistics:downed( { death = true } )
			IngameFatalState.on_local_player_dead()
			game_state_machine:change_state_by_name("ingame_waiting_for_respawn")
			self._unit:character_damage():set_invulnerable( true )
			self._unit:character_damage():set_health(0)
			self._unit:base():_unregister()
			self._unit:base():set_slot(self._unit, 0)
			_unit_alive_track = 0
			managers.player.locke:delete_unit()
		end
		if managers.player.locke:parent() and managers.player.locke:parent():movement()._current_state_name == "mask_off" then
			_current_state_name = managers.player.locke:parent():movement()._current_state_name
			managers.player.locke:unit():movement():set_character_anim_variables()
			managers.player.locke:unit():movement():set_cool(true)
			managers.player.locke:unit():brain():on_cool_state_changed(true)
		end
		if managers.player.locke:parent():movement()._current_state_name ~= "mask_off" and _current_state_name ~= managers.player.locke:parent():movement()._current_state_name then
			_current_state_name = managers.player.locke:parent():movement()._current_state_name
			managers.player.locke:unit():movement():set_character_anim_variables()
			managers.player.locke:unit():movement():set_cool(false)
			managers.player.locke:unit():brain():on_cool_state_changed(false)
			managers.groupai:state():_clear_criminal_suspicion_data()
		end
		if t > _talk_dealy then
			_talk_dealy = t + 30
			local instigator = managers.player:player_unit()
			local _id = math.random(1, 71)
			_id = _id < 10 and "Play_loc_jr1_0" .. _id or "Play_loc_jr1_" .. _id
			if math.random(1, 2) == 2 then
				_id = math.random(1, 43)
				_id = _id < 10 and "Play_loc_jr2_0" .. _id or "Play_loc_jr2_" .. _id
			end
			managers.dialog:quit_dialog()
			managers.dialog:queue_dialog(_id, {
				case = managers.criminals:character_name_by_unit(instigator),
				done_cbk = nil,
				position = nil,
				skip_idle_check = Application:editor(),
				on_unit = instigator
			})
		end
		if t > _primary_anim_recover_delay and _primary_anim_recover_delay > 0 then
			managers.player.locke:unit():movement():play_redirect("recoil_single")
			_primary_anim_recover_delay = 0
		end
	end
end
local _get_input = PlayerStandard._get_input
function PlayerStandard:_get_input(t, dt)
	local input = _get_input(self, t, dt)
	if managers.player.locke:is_ragdoll() then
		for i,v in pairs(input)do
			if v and (i == "btn_primary_attack_state") then
				managers.player.locke:update_ragdoll_velocity(2)
			end
			if i ~= "btn_weapon_gadget_press" and i ~= "btn_melee_press" then
				input[i] = false
			end
		end
	end
	return input
end
local enter = PlayerStandard.enter
function PlayerStandard:enter(state_data, enter_data)
	enter(self, state_data, enter_data)
	managers.player.locke:stop_sound()
	managers.player.locke:revive()
	return
end
local _stance_entered = PlayerStandard._stance_entered
function PlayerStandard:_stance_entered(unequipped)
	local def = self._state_data.ducking
	self._state_data.ducking = true
	_stance_entered(self, unequipped)
	self._state_data.ducking = def
end
function PlayerStandard:locke_play_anim(anim, t)
	if managers.player.locke:anim_type(self._last_anim_locke) ~= managers.player.locke:anim_type(anim) then
		local len = managers.player.locke:anim_leng(self._last_anim_locke) or 0
		if self._anim_start_t_locke and (self._anim_start_t_locke + len) > t then
			return
		end
	end
	managers.player.locke:play_seq(anim)
	self._last_anim_locke = anim
	self._anim_start_t_locke = t
end
function PlayerStandard:locke_get_move_dir()
	if not self._move_dir then
		return
	end
	local fwd_new = managers.player.locke:unit():rotation():y()
	local right_new = fwd_new:cross(math.UP)
	local walk_dir_flat = self._move_dir:with_z(0)
	mvector3.normalize(walk_dir_flat)
	local fwd_dot = walk_dir_flat:dot(fwd_new)
	local right_dot = walk_dir_flat:dot(right_new)
	if math.abs(fwd_dot) > math.abs(right_dot) then
		return fwd_dot > 0 and "f" or "b"
	else
		return right_dot > 0 and "r" or "l"
	end
end
local _determine_move_direction = PlayerStandard._determine_move_direction
function PlayerStandard:_determine_move_direction()
	_determine_move_direction(self)
	if managers.player.locke:is_ragdoll() then
		if self._move_dir then
			managers.player.locke:update_ragdoll_velocity(2)
		end
		self._move_dir = nil
		self._normal_move_dir = nil
	end
end
local _update_movement = PlayerStandard._update_movement
function PlayerStandard:_update_movement(t, dt)
	_update_movement(self, t, dt)
	if not managers.player.locke:can_walk() then
		return
	end
	local anim_side
	if self._last_velocity_xy then
		local fwd_new = managers.player.locke:unit():rotation():y()
		local right_new = fwd_new:cross(math.UP)
		local walk_dir_flat = self._last_velocity_xy:with_z(0)
		mvector3.normalize(walk_dir_flat)
		local fwd_dot = walk_dir_flat:dot(fwd_new)
		local right_dot = walk_dir_flat:dot(right_new)
		if math.abs(fwd_dot + 0.1) > math.abs(right_dot) then
			anim_side = fwd_dot > 0 and "walk_fwd" or "walk_bwd"
		else
			anim_side = right_dot > 0 and "walk_l" or "walk_r"
		end
		local vel_len = mvector3.length(self._last_velocity_xy)
		if vel_len > 500 and anim_side == "walk_fwd" then
			anim_side = "sprint_fwd"
		elseif vel_len > 500 and anim_side == "walk_bwd" then
			anim_side = "sprint_bwd"
		elseif vel_len > 500 and anim_side == "walk_l" then
			anim_side = "sprint_l"
		elseif vel_len > 500 and anim_side == "walk_r" then
			anim_side = "sprint_r"
		elseif vel_len < 1 then
			anim_side = "idle"
		end
	end

	if self._last_anim_locke ~= anim_side then
		managers.player.locke:unit():movement():play_redirect(anim_side)
		self._last_anim_locke = anim_side
	end
end
--
local _update_foley = PlayerStandard._update_foley
function PlayerStandard:_update_foley(t, input)
	_update_foley(self, t, input)
	if not self._state_data.in_air and managers.player.locke:pitch() ~= 0 then
		local o = 10
		local p = managers.player.locke:pitch()
		if o < p and (360 - o) > p then
			managers.player.locke:ragdoll()
		end
		managers.player.locke:set_pitch(0)
	end
end
--flip
function PlayerStandard:_check_action_steelsight(t, input)
	local new_action
	if input.btn_steelsight_state and self._state_data.in_air and self._move_dir then
		local fwd_new = self._ext_movement:m_head_rot():y()
		local walk_dir_flat = self._move_dir:with_z(0)
		mvector3.normalize(walk_dir_flat)
		local fwd_dot = walk_dir_flat:dot(fwd_new)
		if fwd_dot ~= 0 then
			local p = (fwd_dot > 0) and -1 or 1
			managers.player.locke:add_pitch(p * 1)
		end
	end
	return new_action
end

function PlayerStandard:locke_attack_damage(t)
	self._state_data.meleeing = nil
	self._state_data.melee_feet = nil
	if not managers.player.locke:can_walk() then
		return
	end
	local range = 150
	local from = managers.player.locke:unit():position() + GoatManager.HEIGHT
	local to = from + managers.player.locke:unit():rotation():y() * range * 1
	local sphere_cast_radius = 60
	local col_ray = self._unit:raycast("ray", from, to, "ignore_unit", managers.player.locke:unit(), "slot_mask", self._slotmask_bullet_impact_targets, "sphere_cast_radius", sphere_cast_radius, "ray_type", "body melee")
	if col_ray then
		local damage = 50
		col_ray.sphere_cast_radius = sphere_cast_radius
		local hit_unit = col_ray.unit
		managers.game_play_central:play_impact_flesh({col_ray = col_ray})
		managers.game_play_central:play_impact_sound_and_effects({
			col_ray = col_ray,
			no_decal = true,
			no_sound = true
		})
		if hit_unit:damage() and col_ray.body:extension() and col_ray.body:extension().damage then
			col_ray.body:extension().damage:damage_melee(self._unit, col_ray.normal, col_ray.position, col_ray.ray, damage)
			if hit_unit:id() ~= -1 then
				managers.network:session():send_to_peers_synched("sync_body_damage_melee", col_ray.body, self._unit, col_ray.normal, col_ray.position, col_ray.ray, damage)
			end
		end
		local character_unit, shield
		if hit_unit:in_slot(8) and alive(hit_unit:parent()) then
			character_unit = hit_unit:parent()
			shield = hit_unit
		end
		character_unit = character_unit or hit_unit
		if character_unit:character_damage() and character_unit:character_damage().damage_melee then
			local dmg_multiplier = 1
			local action_data = {}
			action_data.variant = "melee"
			action_data.damage = damage * dmg_multiplier
			action_data.damage_effect = damage
			action_data.attacker_unit = self._unit
			action_data.col_ray = col_ray
			action_data.name_id = "fists"
			action_data.charge_lerp_value = 0
			local defense_data = CopDamage.damage_melee(character_unit:character_damage(), action_data)--character_unit:character_damage():damage_melee(action_data)
			return defense_data
		end
	end
	
	return col_ray
end
local _primary_attack_delay = 0
function PlayerStandard:_check_action_primary_attack(t, input)
	if _primary_attack_delay > t then
		return
	end
	_primary_attack_delay = t + 0.15
	local action_wanted = input.btn_primary_attack_state or input.btn_primary_attack_release
	if not action_wanted then
		return
	end
	local action_forbidden = self:_is_reloading() or self:_changing_weapon() or self:_is_meleeing() or self._use_item_expire_t or self:_interacting() or self:_is_throwing_projectile() or self:_is_deploying_bipod()
	if action_forbidden then
		return
	end
	local _weap_unit = managers.player.locke:unit():inventory():equipped_unit() or nil
	if _weap_unit then
		local _weapon_base = _weap_unit:base() or nil
		if _weapon_base then
			if _weapon_base:clip_empty() then
				_weap_unit:base():on_reload()
				return
			end
			local from = _weap_unit:position() + Vector3(0,0,50)
			local to = Vector3()
			mvector3.set(to, self._unit:camera():rotation():y())
			mvector3.multiply(to, 20000)
			mvector3.add(to, from)			
			local col_ray = self._unit:raycast("ray", from, to, "ignore_unit", managers.player.locke:unit(), "slot_mask", self._slotmask_bullet_impact_targets)
			local target_vec = col_ray and col_ray.ray or to
			if col_ray and col_ray.ray then
				if col_ray.unit then
					local damage = 20
					local hit_unit = col_ray.unit
					if hit_unit:damage() and col_ray.body:extension() and col_ray.body:extension().damage then
						col_ray.body:extension().damage:damage_bullet(self._unit, col_ray.normal, col_ray.position, col_ray.ray, damage)
						if hit_unit:id() ~= -1 then
							managers.network:session():send_to_peers_synched("sync_body_damage_bullet", col_ray.body, self._unit, col_ray.normal, col_ray.position, col_ray.ray, damage)
						end
					end
					local character_unit, shield
					if hit_unit:in_slot(8) and alive(hit_unit:parent()) then
						character_unit = hit_unit:parent()
						shield = hit_unit
					end
					character_unit = character_unit or hit_unit
					if character_unit:character_damage() and character_unit:character_damage().damage_bullet then
						local action_data = {}
						action_data.variant = "bullet"
						action_data.damage = damage
						action_data.weapon_unit = _weap_unit
						action_data.attacker_unit = self._unit
						action_data.col_ray = col_ray
						character_unit:character_damage():damage_bullet(action_data)
					end
				end
			end
			_primary_anim_recover_delay = t + 1
			managers.player.locke:unit():movement():play_redirect("recoil_auto")
			_weapon_base:singleshot(from, target_vec, 5)
		end
	end
	return
end

function PlayerStandard:_check_action_melee(t, input)
	local action_wanted = input.btn_melee_press
	if not action_wanted then
		return
	end
	local action_forbidden = self:_is_reloading() or self:_changing_weapon() or self:_is_meleeing() or self._use_item_expire_t or self:_interacting() or self:_is_throwing_projectile() or self:_is_deploying_bipod()
	if action_forbidden then
		return
	end
	self._state_data.melee_expire_t = self._state_data.melee_expire_t or 0
	if input.btn_melee_press and self._state_data.melee_expire_t and t >= self._state_data.melee_expire_t then
		self:locke_attack_damage(t)
		managers.player.locke:do_melee_attack(t)
		self._state_data.melee_expire_t = t + 0.4
	end
	return
end